{
WELCOME TO THE DBGONZALES DEMO !

dbGonzales Copyright (C) 1987 - 2004 by VEITH SYSTEM GmbH and Adrian Veith.
GDemo Copyright (C) 2004 by VEITH SYSTEM GmbH.

This software is provided 'as-is', without any expressed or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software. 

Without any written permission, you may use this software only for testing purposes. You may redistribute it freely under the following restrictions:

1. The origin of this software must not be misrepresented. You must not claim that you wrote the original software.

2. This notice may not be removed or altered from any distribution.
}
unit uGDemo;
{$INCLUDE vConditions.inc}

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
{$IFDEF COMPILER6_UP}
  Variants,
{$ENDIF}
	GdfDataSet, Db, ImgList, ActnList, ToolWin, ComCtrls, ExtCtrls,
	GdfBase, GdfExpr, GdfFieldExpr, GdfQuery, GRuntime, GdfList, Buttons,
	Math;

type
	TPaintObject = class(TGdfInterfaceObject)
	private
		FPointY: TGdfIntegerField;
		FPointX: TGdfIntegerField;
		FColor: TGdfIntegerField;
		FParentID: TGdfObjectIDField;
	published
		property ParentID: TGdfObjectIDField read FParentID write FParentID;
		property PointX: TGdfIntegerField read FPointX write FPointX;
		property PointY: TGdfIntegerField read FPointY write FPointY;
		property Color: TGdfIntegerField read FColor write FColor;
	public
		procedure PaintTo(Canvas: TCanvas; Origin: TPoint); virtual;
	end;
	TPaintLine = class(TPaintObject)
	private
		FPointY2: TGdfIntegerField;
		FPointX2: TGdfIntegerField;
	published
		property PointX2: TGdfIntegerField read FPointX2 write FPointX2;
		property PointY2: TGdfIntegerField read FPointY2 write FPointY2;
	public
		procedure PaintTo(Canvas: TCanvas; Origin: TPoint); override;
	end;
	TPaintRectangle = class(TPaintObject)
	private
		FHeight: TGdfIntegerField;
		FWidth: TGdfIntegerField;
	published
		property Height: TGdfIntegerField read FHeight write FHeight;
		property Width: TGdfIntegerField read FWidth write FWidth;
	public
		procedure PaintTo(Canvas: TCanvas; Origin: TPoint); override;
	end;
	TPaintEllipse = class(TPaintObject)
	private
		FRadius2: TGdfIntegerField;
		FRadius1: TGdfIntegerField;
	published
		property Radius1: TGdfIntegerField read FRadius1 write FRadius1;
		property Radius2: TGdfIntegerField read FRadius2 write FRadius2;
	public
		procedure PaintTo(Canvas: TCanvas; Origin: TPoint); override;
	end;
	TRepaintThread = class(TThread)
	private
		FDatabase: TGDataBase;
		FImage: TImage;
		FBitmap: TBitmap;
		FLastDuration: Integer;
		FCountObjects: Integer;
		FOnStatistic: TNotifyEvent;
	protected
		procedure Execute; override;
		procedure RepaintBitmap;
		procedure Statistics;
	public
		constructor Create(ADatabase: TGDataBase; AImage: TImage);
		destructor Destroy; override;
		property LastDuration: Integer read FLastDuration;
		property CountObjects: Integer read FCountObjects;
		property OnStatistic: TNotifyEvent read FOnStatistic write FOnStatistic;
	end;
	TfGDemo = class(TForm)
		ToolBar1: TToolBar;
		ActionList1: TActionList;
		ImageList1: TImageList;
		GDemo: TGDataBase;
		TADemo: TGTransaction;
		acAddRandom: TAction;
		ToolButton3: TToolButton;
		ToolButton4: TToolButton;
		StatusBar1: TStatusBar;
		TARepaint: TGTransaction;
		GDemoRepaint: TGDataBase;
    acAnimate1: TAction;
    btnAnimate: TSpeedButton;
    Demo: TGTable;
    ScrollBox1: TScrollBox;
    Image1: TImage;
		procedure FormCreate(Sender: TObject);
		procedure acAddRandomExecute(Sender: TObject);
		procedure FormDestroy(Sender: TObject);
		procedure acAnimate1Execute(Sender: TObject);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
	private
		{ Private-Deklarationen }
		FRepaintThread: TRepaintThread;
		procedure DoStatistic(Sender: TObject);
		procedure TestConnection; 
	public
		{ Public-Deklarationen }
	end;

var
	fGDemo: TfGDemo;

implementation

uses ufStartup;

const
	cGDEMO = 'GDEMO';
	Colors : array[0..6] of TColor = (clBlack, clRed, clGreen, clBlue,
		clNavy, clLime, clYellow);

{$R *.DFM}

{ TPaintObject }

procedure TPaintObject.PaintTo(Canvas: TCanvas; Origin: TPoint);
begin
	Canvas.Brush.Color:= Color.Value;
end;

{ TPaintLine }

procedure TPaintLine.PaintTo(Canvas: TCanvas; Origin: TPoint);
begin
	Canvas.Pen.Color:= Color.Value;
	inc(Origin.x, PointX.Value);
	inc(Origin.y, PointY.Value);
	Canvas.MoveTo(Origin.x, Origin.y);
	inc(Origin.x, PointX2.Value);
	inc(Origin.y, PointY2.Value);
	Canvas.LineTo(Origin.x, Origin.y);
end;

{ TPaintRectangle }

procedure TPaintRectangle.PaintTo(Canvas: TCanvas; Origin: TPoint);
var
	Rect: TRect;
begin
	inherited;
	Rect.Left:= PointX.Value + Origin.x;
	Rect.Top:= PointY.Value + Origin.y;
	Rect.Right:= Rect.Left + Width.Value;
	Rect.Bottom:= Rect.Top + Height.Value;
	Canvas.FillRect(Rect);
end;

{ TPaintEllipse }

procedure TPaintEllipse.PaintTo(Canvas: TCanvas; Origin: TPoint);
var
	Rect: TRect;
begin
	inherited;
	Rect.Left:= PointX.Value + Origin.x;
	Rect.Top:= PointY.Value + Origin.y;
	Rect.Right:= Rect.Left + 2 * Radius1.Value;
	Rect.Bottom:= Rect.Top + 2 * Radius2.Value;
	Canvas.Ellipse(Rect);
end;

{ TRepaintThread }

constructor TRepaintThread.Create(ADatabase: TGDataBase; AImage: TImage);
begin
	inherited Create(True);
	FDatabase:= ADatabase;
	FImage:= AImage;
	FBitmap:= TBitmap.Create;
	FBitmap.Height:= FImage.Picture.Height;
	FBitmap.Width:= FImage.Picture.Width;
	FreeOnTerminate:= False;
	Resume;
end;

destructor TRepaintThread.Destroy;
begin
	inherited;
	FBitmap.Free;
	FDatabase.Transaction.Active:= False;
	FDatabase.Connected:= False;
end;

procedure TRepaintThread.Execute;
var
	LastTAN, newTAN: TGdfTAN;
	duration: Cardinal;
	times: Integer;
begin
	LastTAN:= 0;
	times:= 0;
	while not Terminated do try
		FDatabase.Transaction.CommitRetaining;
		newTAN:= FDatabase.Storage.Filer.TAInfo.m_TAN;
		if (LastTAN <> newTAN) then
			times:= 0;
		if times <= 1 then begin
			inc(times);
			LastTAN:= newTAN;
			duration:= GetTickCount;
			try
				RepaintBitmap;
			except
			end;
			FLastDuration:= GetTickCount - duration;
			Synchronize(Statistics);
		end;
		Sleep(40);
	except
		Terminate;
	end;
end;

procedure TRepaintThread.RepaintBitmap;
var
	qy: TGdfFilteredTableOp;
	tb: TGdfTable;
	obj: TPaintObject;
	cnt: Integer;
const
	ZeroPt: TPoint = (x: 0; y: 0);
begin
	tb:= nil;
	qy:= nil;
	if FBitmap.Canvas.TryLock then try
		FBitmap.Canvas.Brush.Color:= clWhite;
		FBitmap.Canvas.FillRect(Rect(0, 0, FBitmap.Width, FBitmap.Height));
		tb:= FDatabase.Storage.CreateTableInstance(cGDEMO);
		qy:= TGdfFilteredTableOp.Create(tb, [],
			TfComp.New(tb.BaseClass.FieldByName('ParentID'), TvVariant.Val(Null), [cvEQ]));
// don't bother the query-compiler with a simple query.			
		cnt:= 0;
		qy.Start;
		while qy.Step do begin
			obj:= TPaintObject(tb.CurrentInterface);
			if obj <> nil then begin
				obj.PaintTo(FBitmap.Canvas, ZeroPt);
				inc(cnt);
			end;
		end;
		FCountObjects:= cnt;
		if FImage.Canvas.TryLock then try
			FImage.Canvas.Draw(0, 0, FBitmap);
		finally
			FImage.Canvas.Unlock;
		end;
	finally
		FBitmap.Canvas.Unlock;
		tb.Free;
		qy.Free;
	end;
end;

procedure TRepaintThread.Statistics;
begin
	if Assigned(FOnStatistic) then
		FOnStatistic(Self);
end;

{ TForm1 }

procedure TfGDemo.FormCreate(Sender: TObject);
begin
	Randomize;
	with TfStartup.Create(Self) do try
		if ShowModal <> mrOK then begin
			Application.Terminate;
			exit;
		end;
	finally
		Free;
	end;
	Image1.Picture.Bitmap.Height:= Screen.Height;
	Image1.Picture.Bitmap.Width:= Screen.Width;
	GDemo.Connected:= True;
	TADemo.Active:= True;
	if (GDemo.Storage.BadInterfaceClassesCount > 0)
		or (GDemo.Storage.FindClass(TPaintObject) = nil)
		or (GDemo.Storage.FindClass(TPaintLine) = nil)
		or (GDemo.Storage.FindClass(TPaintRectangle) = nil)
		or (GDemo.Storage.FindClass(TPaintEllipse) = nil)
		or (GDemo.Storage.GetItemListByName(cGDEMO) = nil)
	then begin
		GDemo.Storage.DDL('drop ' + cGDEMO);
		GDemo.Storage.DDL('drop TPaintObject');
		GDemo.Storage.CreateItemClass(TPaintObject);
		GDemo.Storage.CreateItemClass(TPaintLine);
		GDemo.Storage.CreateItemClass(TPaintRectangle);
		GDemo.Storage.CreateItemClass(TPaintEllipse);
		GDemo.Storage.DDL('create table ' + cGDEMO + ' on TPaintObject');
		GDemo.Storage.DDL('create index idxParentID on ' + cGDEMO + ' (ParentID)');
		TADemo.CommitRetaining;
	end;
	Demo.Active:= True;
	GDemoRepaint.Connected:= True;
	TARepaint.Active:= True;
	FRepaintThread:= TRepaintThread.Create(GDemoRepaint, Image1);
	FRepaintThread.OnStatistic:= DoStatistic;
end;

procedure TfGDemo.acAddRandomExecute(Sender: TObject);

	procedure SetRandomObject(O: TPaintObject; MaxX, MaxY: Integer);
	begin
		O.PointX.Value:= Random(MaxX);
		O.PointY.Value:= Random(MaxY);
		O.Color.Value:= Colors[Random(Length(Colors))];
	end;

	procedure CreateRandomRectangle(tb: TGdfTable; MaxX, MaxY: Integer);
	var
		O: TPaintRectangle;
	begin
		O:= TPaintRectangle(tb.Append(TPaintRectangle));
		SetRandomObject(O, MaxX, MaxY);
		O.Height.Value:= Random(10) + 1;
		O.Width.Value:= Random(10) + 1;
	end;

	procedure CreateRandomEllipse(tb: TGdfTable; MaxX, MaxY: Integer);
	var
		O: TPaintEllipse;
	begin
		O:= TPaintEllipse(tb.Append(TPaintEllipse));
		SetRandomObject(O, MaxX, MaxY);
		O.Radius1.Value:= Random(10) + 1;
		O.Radius2.Value:= Random(10) + 1;
	end;

	procedure CreateRandomLine(tb: TGdfTable; MaxX, MaxY: Integer);
	var
		O: TPaintLine;
	begin
		O:= TPaintLine(tb.Append(TPaintLine));
		SetRandomObject(O, MaxX, MaxY);
		O.PointX2.Value:= Random(40) + 1;
		O.PointY2.Value:= Random(40) + 1;
	end;

var
	i: Integer;
	tb: TGdfTable;
begin
	TestConnection;
	tb:= Demo.GdfTable;
	for i:= 1 to 1000 do begin
		case Random(7) of
			0, 1, 2: CreateRandomRectangle(tb, Screen.Width, Screen.Height);
			3: CreateRandomEllipse(tb, Screen.Width, Screen.Height);
			4, 5, 6: CreateRandomLine(tb, Screen.Width, Screen.Height);
		end;
		tb.Post;
	end;
	TADemo.CommitRetaining;
end;

procedure TfGDemo.FormDestroy(Sender: TObject);
begin
	if FRepaintThread <> nil then begin
		FRepaintThread.Terminate;
		FRepaintThread.WaitFor;
		FRepaintThread.Free;
	end;
	GDemo.Connected:= False;
	GDemoRepaint.Connected:= False;
end;

procedure TfGDemo.acAnimate1Execute(Sender: TObject);

	function NewPos(OldPos, Range, Max: Integer): Integer;
	begin
		Result:= (Max + OldPos + Random(Range) - (Range div 2)) mod Max;
	end;

	procedure TryCommit(oldId: TGdfObjectID);
	begin
		try
			TADemo.CommitRetaining;
		except
			TestConnection;
			TADemo.RollbackRetaining;
		end;
		if not Demo.Locate('ThisID', ObjectIDToVariant(oldId), []) then
			Demo.First;
		Application.ProcessMessages;
	end;

var
	tb: TGdfTable;
	cnt: Integer;
	obj: TPaintObject;
	deltaX, deltaY, distance, radius, range: Integer;
	CenterPt: TPoint;
	SearchColor: TColor;
	TickNewSet, TickNextCommit: Cardinal;
begin
	if not btnAnimate.Down then exit;
	TestConnection;
	TickNewSet:= 0;
	if Demo.RecordCount < 100 then
		acAddRandom.Execute;
	Demo.IndexFieldNames:= 'ParentID';
	Demo.SetRange([Null],[Null]);
	try
		tb:= Demo.GdfTable;
		while btnAnimate.Down do begin
			if GetTickCount > TickNewSet then begin
				TickNewSet:= GetTickCount + 20000;
				CenterPt.x:= Screen.Width div 4;
				CenterPt.y:= Screen.Height div 4;
				CenterPt:= Point(CenterPt.x + Random(CenterPt.x * 2),
					CenterPt.y + Random(CenterPt.y * 2));
				radius := Random(Screen.Width div 4 -50) + 50;
				if Random(Length(Colors) + 1)=0 then
					SearchColor:= clNone
				else
					SearchColor:= Colors[Random(Length(Colors))];
			end;
			cnt:= 0;
			TickNextCommit:= GetTickCount + 40;
			tb.First;
			obj:= nil;
			while not tb.Eof do begin
				obj:= TPaintObject(tb.CurrentInterface);
				if obj <> nil then begin
					deltaX:= CenterPt.x - obj.PointX.Value;
					deltaY:= CenterPt.y - obj.PointY.Value;
					distance:= Abs(Round(Sqrt(deltaX * deltaX + deltaY * deltaY)) - radius);
					if distance < 10 then begin
						range:= 2;
					end else begin
						range:= 1 + (distance * distance) div 100;
						if range > distance then range:= distance;
					end;
					if (SearchColor = clNone)
						or (SearchColor = obj.Color.Value)
					then begin
						tb.Edit;
						obj.PointX.Value:= NewPos(obj.PointX.Value, range, Screen.Width);
						obj.PointY.Value:= NewPos(obj.PointY.Value, range, Screen.Height);
						tb.Post;
						inc(cnt);
					end;
					if (cnt > 500)
						or (TickNextCommit < GetTickCount)
					then begin
						cnt:= 0;
						TryCommit(obj.ThisID.Value);
						tb:= Demo.GdfTable;
						if not btnAnimate.Down then
							break;
						TickNextCommit:= GetTickCount + 40;
					end;
				end;
				tb.Next;
			end;
			if obj <> nil then
				TryCommit(obj.ThisID.Value);
			tb:= Demo.GdfTable;
		end;
	finally
		Demo.CancelRange;
	end;
end;

procedure TfGDemo.DoStatistic(Sender: TObject);
begin
	if Sender is TRepaintThread then begin
		StatusBar1.SimpleText:= Format('Painted %d objects in %d ms',
			[TRepaintThread(Sender).CountObjects, TRepaintThread(Sender).LastDuration]);
	end;
end;

procedure TfGDemo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	btnAnimate.Down:= False;
end;

procedure TfGDemo.TestConnection;
begin
	try
		TADemo.CommitRetaining;
	except
		MessageDlg('Lost connection to database! Application will be terminated.', mtError, [mbOK], 0);
		Application.Terminate;
		Abort;
	end;
end;

initialization
	GdfFactory.Add(TPaintObject);
	GdfFactory.Add(TPaintLine);
	GdfFactory.Add(TPaintRectangle);
	GdfFactory.Add(TPaintEllipse);

end.
